/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAwardStatsPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.stats.StatsCounter;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class ServerStatsCounter
extends StatsCounter {
    private static final Logger f_12809_ = LogUtils.getLogger();
    private final MinecraftServer f_12810_;
    private final File f_12811_;
    private final Set<Stat<?>> f_12812_ = Sets.newHashSet();

    public ServerStatsCounter(MinecraftServer p_12816_, File p_12817_) {
        this.f_12810_ = p_12816_;
        this.f_12811_ = p_12817_;
        for (Map.Entry entry : SpigotConfig.forcedStats.entrySet()) {
            Stat<ResourceLocation> wrapper = Stats.f_12988_.m_12902_((ResourceLocation)entry.getKey());
            this.f_13013_.put(wrapper, ((Integer)entry.getValue()).intValue());
        }
        if (p_12817_.isFile()) {
            try {
                this.m_12832_(p_12816_.m_129933_(), FileUtils.readFileToString((File)p_12817_));
            }
            catch (IOException ioexception) {
                f_12809_.error("Couldn't read statistics file {}", (Object)p_12817_, (Object)ioexception);
            }
            catch (JsonParseException jsonparseexception) {
                f_12809_.error("Couldn't parse statistics file {}", (Object)p_12817_, (Object)jsonparseexception);
            }
        }
    }

    public void m_12818_() {
        if (SpigotConfig.disableStatSaving) {
            return;
        }
        try {
            FileUtils.writeStringToFile((File)this.f_12811_, (String)this.m_12845_());
        }
        catch (IOException ioexception) {
            f_12809_.error("Couldn't save stats", (Throwable)ioexception);
        }
    }

    @Override
    public void m_6085_(Player p_12827_, Stat<?> p_12828_, int p_12829_) {
        if (SpigotConfig.disableStatSaving) {
            return;
        }
        super.m_6085_(p_12827_, p_12828_, p_12829_);
        this.f_12812_.add(p_12828_);
    }

    private Set<Stat<?>> m_12851_() {
        HashSet set = Sets.newHashSet(this.f_12812_);
        this.f_12812_.clear();
        return set;
    }

    public void m_12832_(DataFixer p_12833_, String p_12834_) {
        block12: {
            try {
                try (JsonReader jsonreader = new JsonReader((Reader)new StringReader(p_12834_));){
                    jsonreader.setLenient(false);
                    JsonElement jsonelement = Streams.parse((JsonReader)jsonreader);
                    if (!jsonelement.isJsonNull()) {
                        CompoundTag compoundtag = ServerStatsCounter.m_12830_(jsonelement.getAsJsonObject());
                        if (!compoundtag.m_128425_("DataVersion", 99)) {
                            compoundtag.m_128405_("DataVersion", 1343);
                        }
                        if (!(compoundtag = NbtUtils.m_129213_((DataFixer)p_12833_, (DataFixTypes)DataFixTypes.STATS, (CompoundTag)compoundtag, (int)compoundtag.m_128451_("DataVersion"))).m_128425_("stats", 10)) {
                            break block12;
                        }
                        CompoundTag compoundtag1 = compoundtag.m_128469_("stats");
                        Iterator<String> iterator = compoundtag1.m_128431_().iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                break block12;
                            }
                            String s = iterator.next();
                            if (!compoundtag1.m_128425_(s, 10)) continue;
                            Util.m_137521_(Registry.f_122867_.m_6612_(new ResourceLocation(s)), p_12844_ -> {
                                CompoundTag compoundtag2 = compoundtag1.m_128469_(s);
                                for (String s1 : compoundtag2.m_128431_()) {
                                    if (compoundtag2.m_128425_(s1, 99)) {
                                        Util.m_137521_(this.m_12823_((StatType)p_12844_, s1), p_144252_ -> this.f_13013_.put(p_144252_, compoundtag2.m_128451_(s1)), () -> f_12809_.warn("Invalid statistic in {}: Don't know what {} is", (Object)this.f_12811_, (Object)s1));
                                        continue;
                                    }
                                    f_12809_.warn("Invalid statistic value in {}: Don't know what {} is for key {}", new Object[]{this.f_12811_, compoundtag2.m_128423_(s1), s1});
                                }
                            }, () -> f_12809_.warn("Invalid statistic type in {}: Don't know what {} is", (Object)this.f_12811_, (Object)s));
                        }
                    }
                    f_12809_.error("Unable to parse Stat data from {}", (Object)this.f_12811_);
                }
                return;
            }
            catch (JsonParseException | IOException jsonparseexception) {
                f_12809_.error("Unable to parse Stat data from {}", (Object)this.f_12811_, (Object)jsonparseexception);
            }
        }
    }

    private <T> Optional<Stat<T>> m_12823_(StatType<T> p_12824_, String p_12825_) {
        return Optional.ofNullable(ResourceLocation.m_135820_(p_12825_)).flatMap(p_12824_.m_12893_()::m_6612_).map(p_12824_::m_12902_);
    }

    private static CompoundTag m_12830_(JsonObject p_12831_) {
        CompoundTag compoundtag = new CompoundTag();
        for (Map.Entry entry : p_12831_.entrySet()) {
            JsonPrimitive jsonprimitive;
            JsonElement jsonelement = (JsonElement)entry.getValue();
            if (jsonelement.isJsonObject()) {
                compoundtag.m_128365_((String)entry.getKey(), ServerStatsCounter.m_12830_(jsonelement.getAsJsonObject()));
                continue;
            }
            if (!jsonelement.isJsonPrimitive() || !(jsonprimitive = jsonelement.getAsJsonPrimitive()).isNumber()) continue;
            compoundtag.m_128405_((String)entry.getKey(), jsonprimitive.getAsInt());
        }
        return compoundtag;
    }

    protected String m_12845_() {
        HashMap map = Maps.newHashMap();
        for (Object entry : this.f_13013_.object2IntEntrySet()) {
            Stat stat = (Stat)entry.getKey();
            map.computeIfAbsent(stat.m_12859_(), p_12822_ -> new JsonObject()).addProperty(ServerStatsCounter.m_12846_(stat).toString(), (Number)entry.getIntValue());
        }
        JsonObject jsonobject = new JsonObject();
        for (Map.Entry entry : map.entrySet()) {
            jsonobject.add(Registry.f_122867_.m_7981_((StatType)entry.getKey()).toString(), (JsonElement)entry.getValue());
        }
        JsonObject jsonobject1 = new JsonObject();
        jsonobject1.add("stats", (JsonElement)jsonobject);
        jsonobject1.addProperty("DataVersion", (Number)SharedConstants.m_183709_().getWorldVersion());
        return jsonobject1.toString();
    }

    private static <T> ResourceLocation m_12846_(Stat<T> p_12847_) {
        return p_12847_.m_12859_().m_12893_().m_7981_(p_12847_.m_12867_());
    }

    public void m_12850_() {
        this.f_12812_.addAll((Collection<Stat<?>>)this.f_13013_.keySet());
    }

    public void m_12819_(ServerPlayer p_12820_) {
        Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
        for (Stat<?> stat : this.m_12851_()) {
            object2intmap.put(stat, this.m_13015_(stat));
        }
        p_12820_.f_8906_.m_141995_((Packet<?>)new ClientboundAwardStatsPacket((Object2IntMap)object2intmap));
    }
}

